#include "g_local.h"
#include "m_player.h"
// content masks
//MASK_ALL				(-1)
//MASK_SOLID			(CONTENTS_SOLID|CONTENTS_WINDOW)
//MASK_PLAYERSOLID		(CONTENTS_SOLID|CONTENTS_PLAYERCLIP|CONTENTS_WINDOW|CONTENTS_MONSTER)
//MASK_DEADSOLID		(CONTENTS_SOLID|CONTENTS_PLAYERCLIP|CONTENTS_WINDOW)
//MASK_MONSTERSOLID		(CONTENTS_SOLID|CONTENTS_MONSTERCLIP|CONTENTS_WINDOW|CONTENTS_MONSTER)
//MASK_WATER			(CONTENTS_WATER|CONTENTS_LAVA|CONTENTS_SLIME)
//MASK_OPAQUE			(CONTENTS_SOLID|CONTENTS_SLIME|CONTENTS_LAVA)
//MASK_SHOT				(CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_WINDOW|CONTENTS_DEADMONSTER)
//MASK_CURRENT			(CONTENTS_CURRENT_0|CONTENTS_CURRENT_90|CONTENTS_CURRENT_180|CONTENTS_CURRENT_270|CONTENTS_CURRENT_UP|CONTENTS_CURRENT_DOWN)
//MASK_ALPHA			(CONTENTS_ALPHA)
// END JOSEPH

///////////////////////////////////////////////////////////////////////
// Main movement code. (following node path)
///////////////////////////////////////////////////////////////////////
void GHOSTS_Move(edict_t *self, usercmd_t *ucmd)
{
	vec3_t dist;
	int current_node_type=-1;
	int next_node_type=-1;
	int i;

//qboolean debug_mode;  //regular debug on and off
//qboolean debug_state; //what state is the bot in
//qboolean show_nodes; //show node models
//qboolean echo_nodes; //echo node info when added to the map
//qboolean echo_targetnodes; //echo nodes the bots are targeting   
//qboolean draw_path; //draw the node paths 
	

	// Get current and next node back from nav code.
	if(!KOOGLEND_FollowPath(self))
	{
		self->state = BOTSTATE_WANDER;
		self->wander_timeout = level.time + 1.0;
		return;
	}

	current_node_type = nodes[self->current_node].type;
	next_node_type = nodes[self->next_node].type;
		
	///////////////////////////
	// Move To Goal
	///////////////////////////
	if (self->movetarget)
	KOOGLEMV_MoveToGoal(self,ucmd);

	////////////////////////////////////////////////////////
	// Platform Handler
	///////////////////////////////////////////////////////
	PLATFORM_HANDLER
	
	////////////////////////////////////////////////////////
	// Jumpto Node Handler
	///////////////////////////////////////////////////////
	if(next_node_type == BOTNODE_JUMP || 
	  (current_node_type == BOTNODE_JUMP && next_node_type != BOTNODE_ITEM && nodes[self->next_node].origin[2] - 54 > self->s.origin[2]))
	{
        ucmd->upmove = 400;
		ucmd->forwardmove = 400; 
		self->velocity[2] = 450;

	    // Set up a jump move
	    //ucmd->forwardmove = 400;
		
		//TheGhost Chnaged This
		//ucmd->upmove = 400;

		KOOGLEMV_ChangeBotAngle(self);

		VectorCopy(self->move_vector,dist);
		
	    VectorScale(dist,440,self->velocity);
        
		return;
	}
	
	////////////////////////////////////////////////////////
	// Ladder Nodes
	///////////////////////////////////////////////////////
	LADDER_HANDLER
	////////////////////////////////////////////////////////
	// Water Nodes
	///////////////////////////////////////////////////////
    WATER_HANDLER

//	#define BOTNODE_CROUCH 8
	////////////////////////////////////////////////////////
	// Crouch Nodess
	///////////////////////////////////////////////////////
	if(current_node_type == BOTNODE_CROUCH)
	{
		if(random() > 0.1 && GHOSTS_SpecialMove(self, ucmd))
		return;
	}

//	#define BOTNODE_SUPERJUMP 9
	////////////////////////////////////////////////////////
	// SuperJump Nodes
	///////////////////////////////////////////////////////
        if(next_node_type == BOTNODE_SUPERJUMP 
			
			|| (current_node_type == BOTNODE_SUPERJUMP && next_node_type == BOTNODE_SUPERJUMP && nodes[self->next_node].origin[2] - 54 > self->s.origin[2]))
		{
        
		    // Set up a jump move
		    ucmd->forwardmove = 400;
		    ucmd->upmove = 400;

		    KOOGLEMV_ChangeBotAngle(self);

		    VectorCopy(self->move_vector,dist);
		    VectorScale(dist,440,self->velocity);
		    return;

		}

	////////////////////////////////////////////////////////
	// Checks To See If We Are Falling Off The Ledge
	///////////////////////////////////////////////////////
    LEDGE_HANDLER		
	
		
	// Check to see if stuck, and if so try to free us
	// Also handles crouching
 	if(VectorLength(self->velocity) < 37)
	{


		// Keep a random factor just in case....
		//if(random() > 0.1 && KOOGLEMV_SpecialMove(self, ucmd))
		if(random() > 0.1 && GHOSTS_SpecialBoxMove(self, ucmd))
		return;
		
		self->s.angles[YAW] += random() * 180 - 90; 

		/*
        rnd = rand()%3;

		switch(rnd)
		{
		case 0:
            ucmd->upmove = 400;
		    ucmd->forwardmove = 400; 
		    self->velocity[2] = 200;
			break;
		case 1:
            ucmd->forwardmove = 400;
			break;
		case 2:
			ucmd->forwardmove = 400; 
		    ucmd->upmove = -400; 
			break;
		}
        */
	


		ucmd->forwardmove = 400;
		
		return;
	}

	// Otherwise move as fast as we can
	ucmd->forwardmove = 400; 

	KOOGLEMV_ChangeBotAngle(self);
}

//crouching fuck bag
qboolean GHOSTS_SpecialMove(edict_t *self, usercmd_t *ucmd)
{
	vec3_t dir,forward,right,start,end,offset;
	trace_t tr; 
	float c;

    self->currentmove = 8;
	// Get current direction
	VectorCopy(self->client->ps.viewangles,dir);
	dir[YAW] = self->s.angles[YAW];
	AngleVectors (dir, forward, right, NULL);

	VectorSet(offset, 18, 0, 0);
	G_ProjectSource (self->s.origin, offset, forward, right, start);
	offset[0] += 18;
	G_ProjectSource (self->s.origin, offset, forward, right, end);
	
	// Check for jump
	start[2] -= 32;
		
	end[2] -= 32;
		
	tr = gi.trace (start, self->mins, self->maxs, end, self, MASK_MONSTERSOLID);

		if((!tr.allsolid)||(tr.allsolid))
		{	
	        c = random();
	        

			if (KOOGLEMV_CanMove(self,MOVE_FORWARD))
			{
			   ucmd->forwardmove = 475;
			   ucmd->upmove = -400; 
			   //self->velocity[2] = 440;

			   if (Q_stricmp (self->client->pers.netname, "[BM]KidKoogle") == 0)
			   {
   				   if (debug_state)
				   {

                 debug_printf("\n\n-----------------------------------------------------------------------------------\n");
			     debug_printf("GHOSTS_SpecialMove FORWARD CROUCH (forwardmove = 400) (upmove = -400) (velocity = 440) (sidemove = +400)\n");
			     debug_printf("-----------------------------------------------------------------------------------\n");
				   }
			   }
	
			}
            else
		    if(c < 0.2 && KOOGLEMV_CanMove(self,MOVE_LEFT))
			{
			   
			   if (KOOGLEMV_CanMove(self,MOVE_LEFT))
			   ucmd->sidemove += 475; 
            
			   ucmd->upmove = -400; 
			   //self->velocity[2] = 440;

			   if (Q_stricmp (self->client->pers.netname, "[BM]KidKoogle") == 0)
			   {
				   if (debug_state)
				   {

                 debug_printf("\n\n-----------------------------------------------------------------------------------\n");
			     debug_printf("GHOSTS_SpecialMove LEFT CROUCH (forwardmove = 400) (upmove = -400) (velocity = 440) (sidemove = +400)\n");
			     debug_printf("-----------------------------------------------------------------------------------\n");
				   }
			   }
	
			}
		    else if(c < 0.4 && KOOGLEMV_CanMove(self,MOVE_RIGHT))
			{
			    if (KOOGLEMV_CanMove(self,MOVE_RIGHT))
			    ucmd->sidemove -= 475; 
		    
				ucmd->upmove -= -400; 
			    //self->velocity[2] = 440;

			   if (Q_stricmp (self->client->pers.netname, "[BM]KidKoogle") == 0)
			   {
				   if (debug_state)
				   {

                  debug_printf("\n\n-----------------------------------------------------------------------------------\n");
			      debug_printf("GHOSTS_SpecialMove RIGHT CROUCH (forwardmove = 400) (upmove = -400) (velocity = 440) (sidemove = -400)\n");
			      debug_printf("-----------------------------------------------------------------------------------\n");
				   }
			   }

			}

			return true;
			
		
	}

		return true;

}


qboolean GHOSTS_SpecialBoxMove(edict_t *self, usercmd_t *ucmd)
{
	vec3_t dir,forward,right,start,end,offset,dist;
	trace_t tr; 
	float c;

	int current_node_type=-1;
	int next_node_type=-1;

    if (self->currentmove == 8)
	goto iam8;
	// Get current direction
	VectorCopy(self->client->ps.viewangles,dir);
	dir[YAW] = self->s.angles[YAW];
	AngleVectors (dir, forward, right, NULL);

	VectorSet(offset, 18, 0, 0);
	G_ProjectSource (self->s.origin, offset, forward, right, start);
	offset[0] += 18;
	G_ProjectSource (self->s.origin, offset, forward, right, end);
	

	current_node_type = nodes[self->current_node].type;
	next_node_type = nodes[self->next_node].type;
	
	QBLADDER_HANDLER

    if(KOOGLEND_CheckForLadder(self)) 
	return false;

	// Check for jump
	start[2] += 32;
		
	end[2] += 32;
		
	tr = gi.trace (start, self->mins, self->maxs, end, self, MASK_MONSTERSOLID);

		if((!tr.allsolid)||(tr.allsolid))
		{	
	        c = random();
	

		    if(c < 0.2 && KOOGLEMV_CanMove(self,MOVE_LEFT))
			{
			   
			   if (KOOGLEMV_CanMove(self,MOVE_LEFT))
			   ucmd->sidemove += 400; 
            
			   if (KOOGLEMV_CanMove(self,MOVE_FORWARD))
			   ucmd->forwardmove = 400;
			   
			   ucmd->upmove += 400; 
			   self->velocity[2] = 440;

			   if (Q_stricmp (self->client->pers.netname, "[BM]KidKoogle") == 0)
			   {
				   if (debug_state)
				   {
                     debug_printf("\n\n-----------------------------------------------------------------------------------\n");
			         debug_printf("GHOSTS_SpecialBoxMove LEFT JUMP (forwardmove = 400) (upmove = +400) (velocity = 440) (sidemove = +400)\n");
			         debug_printf("-----------------------------------------------------------------------------------\n");
				   }
			   }
	
			}
		    else if(c < 0.4 && KOOGLEMV_CanMove(self,MOVE_RIGHT))
			{
			   if (KOOGLEMV_CanMove(self,MOVE_RIGHT))
			   ucmd->sidemove -= 400; 
			    
				if (KOOGLEMV_CanMove(self,MOVE_FORWARD))
			    ucmd->forwardmove = 400;
			    
				ucmd->upmove += 400; 
			    self->velocity[2] = 440;

			   if (Q_stricmp (self->client->pers.netname, "[BM]KidKoogle") == 0)
			   {
				   if (debug_state)
				   {

                  debug_printf("\n\n-----------------------------------------------------------------------------------\n");
			      debug_printf("GHOSTS_SpecialBoxMove RIGHT JUMP (forwardmove = 400) (upmove = +400) (velocity = 440) (sidemove = -400)\n");
			      debug_printf("-----------------------------------------------------------------------------------\n");
				   }
			   }

			}

			return true;
			
		
	}
 
iam8:;
		return true;
}
	

